//
//  ViewController.swift
//  WIFI_Sample_Code
//
//  Created by on 2021/12/3.
//

import UIKit
import IOS_SWIFT_WIFI_SDK

class ViewController: UIViewController {
    
    @IBOutlet weak var mStackView: UIStackView!
    @IBOutlet weak var mScrollView: UIScrollView!
    
    @IBOutlet weak var IPText: UITextField!
    @IBOutlet weak var PortText: UITextField!
    let gswifi = GTSPL_WIFI()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        IPText.text="192.168.1.174" //default
        PortText.text="8899"
        self.mScrollView.addSubview(mStackView)
        self.mStackView.translatesAutoresizingMaskIntoConstraints = false
        self.mStackView.leadingAnchor.constraint(equalTo: mScrollView.leadingAnchor).isActive=true
        self.mStackView.trailingAnchor.constraint(equalTo: mScrollView.trailingAnchor).isActive=true
        self.mStackView.topAnchor.constraint(equalTo: mScrollView.topAnchor).isActive=true
        self.mStackView.bottomAnchor.constraint(equalTo: mScrollView.bottomAnchor).isActive=true
        self.mStackView.widthAnchor.constraint(equalTo: self.view.widthAnchor).isActive=true
    }
    
    @IBAction func connect_onClick(_ sender: Any) {
        let ip = IPText.text
        let port:Int? = Int(PortText.text!)
        guard ip != "" || port != nil else{
            self.showDialog(title: "Error", msg:"IP or Port is empty.")
            return
        }
        gswifi.openport(IP:ip!, Port:port!){(msg) in //用closure帶callback回傳連線狀態
            self.showDialog(title: "Error", msg:msg)
        }
        showDialog(title: "Connect", msg: "Connected")
        
    }
    
    @IBAction func disconnect_onClick(_ sender: Any) {
        gswifi.closeport()
    }
    
    //setup printer
    @IBAction func setup_onClick(_ sender: Any) {
        gswifi.setup(width: 105, height: 80, speed: 4, density: 6, sensor: 0, sensordistance: 3, sensoroffset:3)
    }
    
    //print barcode
    @IBAction func barcode_onCllick(_ sender: Any) {
        gswifi.clearBuffer()
        gswifi.printBarcode(x: 30, y: 30, type: "128", height: 100, human_readable: 1, rotation: 0, narrow:2, wide: 2, content: "barcode987654321")
        gswifi.printLabel(set: 1, copy: 1)
    }
    
    //print bmp
    @IBAction func bmp_onClick(_ sender: Any)  {
        gswifi.clearBuffer()
        let url = Bundle.main.url(forResource: "CIRCLE", withExtension:"bmp")!
        gswifi.downloadBMP(filepath: url, filename: "CIRCLE.bmp")
        gswifi.sendcommand("PUTBMP 30,30,\"CIRCLE.bmp\"\r\n")
        //gswifi.downloadPCX(filename: "UL")
        //gswifi.sendcommand("PUTPCX 100,100,\"UL.pcx\"\r\n")
        gswifi.printLabel(set: 1, copy: 1)
    }
    
    //print simplified chinese font
    @IBAction func printfont_onClick(_ sender: Any) {
        let cn = "默认简体中文测试：海天米醋白米醋1瓶450ml"
        gswifi.clearBuffer()
        gswifi.printFont(x: 200, y: 200, fontname: "TSS24.BF2", rotation: 0, xScale: 1, yScale: 1, content: cn)
        gswifi.printLabel(set: 1, copy: 1)
    }
    
    //print font block
    @IBAction func onPrintFontBlockClick(_ sender: Any) {
        let paragraph="We stand behind our products with one of the most comprehensive support programs in the Auto-ID industry."
        gswifi.clearBuffer()
        gswifi.printFontBlock(x:15,y:15,width:300,height:90,fontname:"TSS16.BF2",rotation:0,xScale: 2,yScale:2,space:20,align:0,content:paragraph)
        gswifi.printLabel(set: 1, copy: 1)
    }
    
    //get printer status
    @IBAction func status_onClick(_ sender: Any) {
        let status = gswifi.printerStatus()
        var statusStr = ""
        switch status{
        case "00":
            statusStr = "Normal"
        case "01":
            statusStr = "Head opened"
        case "02":
            statusStr = "Paper Jam"
        case "03":
            statusStr = "Paper Jam and head opened"
        case "04":
            statusStr = "Out of paper"
        case "05":
            statusStr = "Out of paper and head opened"
        case "08":
            statusStr = "Out of ribbon"
        case "09":
            statusStr = "Out of ribbon and head opened"
        case "0A":
            statusStr = "Out of ribbon and paper jam"
        case "0B":
            statusStr = "Out of ribbon, paper jam and head opened"
        case "0C":
            statusStr = "Out of ribbon and out of paper"
        case "0D":
            statusStr = "Out of ribbon, out of paper and head opened"
        case "10":
            statusStr = "Pause"
        case "20":
            statusStr = "Printing"
        case "80":
            statusStr = "Other error"
        default:
            break
        }
        showDialog(title:"Printer Status",msg:statusStr)
    }
    
    //get sdk version
    @IBAction func getVersion_Onclick(_ sender: Any) {
        let version = gswifi.getSdkVersion()
        showDialog(title: "WIFI SDK Version", msg: version)
    }
    
    @IBAction func write_EPC_onClick(_ sender: Any) {
        gswifi.writeUHF(dataFormat: "H", startBlockNo:2, byteSize: 12, Gen2MemoryBank: "E", datastring: "414142424343444445454646")
        gswifi.AccessPWD_Action(action: "S", password: "12345678")
        gswifi.EPCPWD_Action(action: "L", password: "12345678")
    }
    
    
    /* 關閉鍵盤 */
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        UIView.animate(withDuration: 0.3) {
            self.view.endEditing(true)
        }
    }
    
    //dialog function
    func showDialog(title:String,msg:String){
        let alertController = UIAlertController(title: title, message: msg, preferredStyle: .alert)
        alertController.addAction(UIAlertAction(title: "OK", style: .default))
        self.present(alertController, animated: true, completion: nil)
    }
}

